unit GistogramService01;
(*
// ========================================================================
//
//                   
//        
//                   3.5
//
// ========================================================================
*)
interface

uses
  //  
  Windows, Messages, SysUtils, Classes, Graphics, Controls,
  Dialogs, StdCtrls, ComCtrls, ExtCtrls, Math,
  //    Image Tools
  MainData,
  //   
  EngineMainData01, EngineImgService01,
  //   
  GistogramMainData01;

// ========================================================================
//                 
//                     
// ========================================================================
//    Image
// (  )
// Cmd:
// 'L' - - 
// 'R' - - 
// 'G' - - 
// 'B' - - 
//
procedure ImgRowGradient(Cmd : Char; RqImg : TImage);
// ------------------------------------------------------------------------
//    Image
// (  )
// Cmd:
// 'L' - - 
// 'R' - - 
// 'G' - - 
// 'B' - - 
//
procedure ImgColGradient(Cmd : Char; RqImg : TImage);

// ========================================================================
//                 
// ========================================================================
//   Image  
procedure NormalizeImageSize(RqImg : TImage; RqW, RqH : integer);

//         
procedure GistPanelPlane(RqPanel : TPanel;
                         RqImgGist, RqImgGrad : TImage;
                         RqGC : char);
//        
procedure FuncPanelPlane(RqPanel : TPanel;
                         RqImgY, RqImgFunc, RqImgX : TImage;
                         RqGC : char);
// ========================================================================
//               
// ========================================================================
// 24.10.2008
//      
procedure ShowGistogram(RqImage : TImage; RqNChanel : array of integer);

// ========================================================================
//               
// ========================================================================
//        
procedure RunAllCalculateAGistogram (RqPtTabBGR  : ptImgTabBGR;
                                     ProgressBar : TProgressBar;
                                     ptGistRec   : ptGistogramRec);
// ------------------------------------------------------------------------

implementation

// ===========================================================================
//                
//                     
// ===========================================================================
// 24.02.2013
//    Image
// (  )
// Cmd:
// 'L' - - 
// 'R' - - 
// 'G' - - 
// 'B' - - 
//
procedure ImgRowGradient(Cmd : Char; RqImg : TImage);
type TpBArr = ^TBArr;
     TBArr = array[0..32767] of Byte;
var  BMCol, BMRow : integer;
     Scale : double;
     L     : byte;
     WRow, WCol   : integer;
     pRow : TpBArr;
begin
  with RqImg.Picture
  do begin
     BitMap.Height := RqImg.Height;
     BitMap.Width  := RqImg.Width;
     BitMap.PixelFormat := pf24bit;
     BMRow := BitMap.Height;
     BMCol := 3 * BitMap.Width;
     Scale := 256 / BitMap.Height;
     for WRow := 0 to (BMRow - 1)
     do begin
        pRow := BitMap.ScanLine[WRow];
        WCol := 0;
        while WCol < BMCol
        do begin
          L := 255 - Trunc(WRow * Scale);
          case UpCase(Cmd) of
          'L' : begin
                 pRow^[WCol]   := L;
                 pRow^[WCol+1] := L;
                 pRow^[WCol+2] := L;
                end;
          'R' : begin
                 pRow^[WCol]   := 0;
                 pRow^[WCol+1] := 0;
                 pRow^[WCol+2] := L;
                end;
          'G' : begin
                 pRow^[WCol]   := 0;
                 pRow^[WCol+1] := L;
                 pRow^[WCol+2] := 0;
                end;
           'B' : begin
                 pRow^[WCol]   := L;
                 pRow^[WCol+1] := 0;
                 pRow^[WCol+2] := 0;
                end;
          end;
          WCol := WCol + 3;
        end;
     end;
  end;
end;
// ------------------------------------------------------------------------
// 24.02.2013
//    Image
// (  )
// Cmd:
// 'L' - - 
// 'R' - - 
// 'G' - - 
// 'B' - - 
//
procedure ImgColGradient(Cmd : Char; RqImg : TImage);
type TpBArr = ^TBArr;
     TBArr = array[0..32767] of Byte;
var  BMCol, BMRow : integer;
     Scale : double;
     L     : byte;
     WRow, WCol   : integer;
     pRow : TpBArr;
begin
  with RqImg.Picture
  do begin
     BitMap.Height := RqImg.Height;
     BitMap.Width  := RqImg.Width;
     BitMap.PixelFormat := pf24bit;
     BMRow := BitMap.Height;
     BMCol := 3 * BitMap.Width;
     Scale := 256 / BitMap.Width;
     for WRow := 0 to (BMRow - 1)
     do begin
        pRow := BitMap.ScanLine[WRow];
        WCol := 0;
        while WCol < BMCol
        do begin
          L := Trunc((WCol div 3) * Scale);
          case UpCase(Cmd) of
          'L' : begin
                 pRow^[WCol]   := L;
                 pRow^[WCol+1] := L;
                 pRow^[WCol+2] := L;
                end;
          'R' : begin
                 pRow^[WCol]   := 0;
                 pRow^[WCol+1] := 0;
                 pRow^[WCol+2] := L;
                end;
          'G' : begin
                 pRow^[WCol]   := 0;
                 pRow^[WCol+1] := L;
                 pRow^[WCol+2] := 0;
                end;
           'B' : begin
                 pRow^[WCol]   := L;
                 pRow^[WCol+1] := 0;
                 pRow^[WCol+2] := 0;
                end;
          end;
          WCol := WCol + 3;
        end;
     end;
  end;
end;

// ========================================================================
//                 
// ========================================================================
// ------------------------------------------------------------------------
// 17.02.2013
//   Image  
procedure NormalizeImageSize(RqImg : TImage; RqW, RqH : integer);
begin
  RqImg.Align := alNone;
  //    Image
  RqImg.Constraints.MinWidth := RqW;
  RqImg.Constraints.MaxWidth := RqW;
  RqImg.Constraints.MinHeight := RqH;
  RqImg.Constraints.MaxHeight := RqH;
end;
// ------------------------------------------------------------------------
// 17.02.2013
//         
procedure GistPanelPlane(RqPanel : TPanel;
                         RqImgGist, RqImgGrad : TImage;
                         RqGC : char);
begin
  RqImgGist.Left := 1;
  RqImgGist.Top  := 1;
  NormalizeImageSize(RqImgGist, GistW, GistH);
  RqImgGrad.Left := RqImgGist.Left;
  RqImgGrad.Top  := RqImgGist.Top + GistH;
  NormalizeImageSize(RqImgGrad, GradW, GradH);
  ImgColGradient(RqGC, RqImgGrad);
  RqPanel.Width  := RqImgGist.Width + 2;
  RqPanel.Height := RqImgGist.Height + RqImgGrad.Height + 2;
end;
// ------------------------------------------------------------------------
// 17.02.2013
//        
procedure FuncPanelPlane(RqPanel : TPanel;
                         RqImgY, RqImgFunc, RqImgX : TImage;
                         RqGC : char);
const FuncA = 512;   //  Image  
      FGrad = 16;    //   
begin
  //---------------
  RqImgY.Left := 1;
  RqImgY.Top  := 1;
  NormalizeImageSize(RqImgY, FGrad, FuncA);
  ImgRowGradient('L', RqImgY);
  //---------------
  RqImgFunc.Left := RqImgY.Left + RqImgY.Width;
  RqImgFunc.Top  := RqImgY.Top;
  NormalizeImageSize(RqImgFunc, FuncA, FuncA);
  //---------------
  RqImgX.Left := RqImgFunc.Left;
  RqImgX.Top  := RqImgFunc.Top + RqImgFunc.Height;
  NormalizeImageSize(RqImgX, FuncA, FGrad);
  ImgColGradient('L', RqImgX);
  //---------------
  RqPanel.Width  := RqImgY.Width + RqImgFunc.Width + 2;
  RqPanel.Height := RqImgFunc.Height + RqImgX.Height + 2;
end;

// ========================================================================
//               
// ========================================================================

// ------------------------------------------------------------------------
// 24.10.2008
//      
procedure ShowGistogram(RqImage : TImage; RqNChanel : array of integer);
var  Ind  : integer;
begin
 with RqImage do
 begin
   Canvas.Brush.Color := clBtnFace;
   Canvas.Brush.Style := bsSolid;
   Canvas.FillRect(Rect(0,0,Width,Height));
   Canvas.Pen.Mode  := pmCopy;
   Canvas.Pen.Color := clBlack;
   Canvas.Pen.Style := psSolid;
  for Ind := 0 to 255 do
  begin
   RqImage.Canvas.MoveTo(Ind, Height);
   RqImage.Canvas.LineTo(Ind, Height - RqNChanel[Ind]);
  end;
 end;
end;

// ========================================================================
//                
// ========================================================================
// 04.04.2014
//  . ,    
procedure CalcMathMDS(ptGistRec : ptGistogramRec);
var Ind   : integer;
begin
   FillChar(ptGistRec^.MDSRec, SizeOf(TMDSRec), #0);
   //     ,  
   if ptGistRec^.NumAllPnt < 2 then Exit;
     //    ptGistRec
     with ptGistRec^, ptGistRec^.MDSRec, ptGistRec^.ChnSrc do
     begin
       // --------------------------
       //  
       for Ind := 1 to 255 do
       //    
       begin
         MR := MR + Ind * ChnR[Ind];   //  Red
         MG := MG + Ind * ChnG[Ind];   //  Green
         MB := MB + Ind * ChnB[Ind];   //  Blue
         ML := ML + Ind * ChnL[Ind];   // Light ()
       end;
       //   . 
       MR := MR / NumAllPnt;   //  Red
       MG := MG / NumAllPnt;   //  Green
       MB := MB / NumAllPnt;   //  Blue
       ML := ML / NumAllPnt;   // Light ()
       // --------------------------
       // 
       for Ind := 0 to 255 do
       //   
       begin
          WEx1 := ChnR[Ind] * (Ind  - MR) * (Ind  - MR);
          DR := DR + WEx1;
          WEx1 := ChnG[Ind] * (Ind  - MG) * (Ind  - MG);
          DG := DG + WEx1;
          WEx1 := ChnB[Ind] * (Ind  - MB) * (Ind  - MB);
          DB := DB + WEx1;
          WEx1 := ChnL[Ind] * (Ind  - ML) * (Ind  - ML);
          DL := DL + WEx1;
       end;
       //   
       DR := DR / NumAllPnt;
       DG := DG / NumAllPnt;
       DB := DB / NumAllPnt;
       DL := DL / NumAllPnt;
       // --------------------------
       //  
       if NumAllPnt > 1
       then SCoef := (NumAllPnt / (NumAllPnt - 1))
       else SCoef := 0;
       SR := Sqrt(SCoef * DR);
       SG := Sqrt(SCoef * DG);
       SB := Sqrt(SCoef * DB);
       SL := Sqrt(SCoef * DL);
     end; // of with
end;

// ========================================================================
//               
// ========================================================================
// 04.04.2014
//   ,     
procedure NormalizeGistogramForImage(ptGistRec : ptGistogramRec);
const GH  = GistH - 4;
var   Ind : word;
begin
  //    
  FillChar(ptGistRec^.ChnNrm, SizeOf(TChannel), #0);
  //     ,  
  if ptGistRec^.NumAllPnt < 1 then Exit;
  //        
  with ptGistRec^ do
  begin
    //       GH - Gistogram Heigth
    for Ind := 0 to 255 do
    begin
      if ChnSrc.ChnMax.MaxR > 0 then
      ChnNrm.ChnR[Ind] := Round( GH * ChnSrc.ChnR[Ind] / ChnSrc.ChnMax.MaxR );
      if ChnSrc.ChnMax.MaxG > 0 then
      ChnNrm.ChnG[Ind] := Round( GH * ChnSrc.ChnG[Ind] / ChnSrc.ChnMax.MaxG );
      if ChnSrc.ChnMax.MaxB > 0 then
      ChnNrm.ChnB[Ind] := Round( GH * ChnSrc.ChnB[Ind] / ChnSrc.ChnMax.MaxB );
      if ChnSrc.ChnMax.MaxL > 0 then
      ChnNrm.ChnL[Ind] := Round( GH * ChnSrc.ChnL[Ind] / ChnSrc.ChnMax.MaxL );
    end;
  end;
end;

// ------------------------------------------------------------------------
// 28.01.2013
//        
procedure RunAllCalculateAGistogram (RqPtTabBGR  : ptImgTabBGR;
                                     ProgressBar : TProgressBar;
                                     ptGistRec   : ptGistogramRec);
const cBPP  = 3;  // Byte Per Pixel (   )
var   Row, Col  : cardinal;
begin
  //  
  if ptGistRec = nil then Exit;
  //        
  FillChar(ptGistRec^, SizeOf(TGistogramRec), #0);
  // ,   ImgTabBGR  
  if not Assigned(RqPtTabBGR) then Exit;

  // ptGistRec^.
  // -----------------------------------
  with ptGistRec^, ptGistRec^.ChnSrc do
  begin
     //   
     LightCoeff := Sqrt(3);
     //     BGR
     ptImgTab := RqPtTabBGR;
     try
       if (Length(RqPtTabBGR^) > 0)
       then begin
          //   
          ProgressBar.Position := 0;
          ProgressBar.Max := (Length(RqPtTabBGR^) - 1);
          //       ImgTableBGR
          for Row := Low(RqPtTabBGR^) to High(RqPtTabBGR^) do
          begin
            for Col := Low(RqPtTabBGR^[Row])
                  to  High(RqPtTabBGR^[Row]) div cBPP do
            begin
              //   (Pointer)   
              ptBGR := Addr(RqPtTabBGR^[Row, cBPP * Col]);
              //   R,G,B  
              ByteR := ptBGR^[2];   //   R   RGB
              ByteG := ptBGR^[1];   //   G   RGB
              ByteB := ptBGR^[0];   //   B   RGB
              //   
              WEx1 :=  Sqrt(ByteR * ByteR + ByteG * ByteG + ByteB * ByteB);
              WEx1 :=  WEx1 / LightCoeff;
              if WEx1 < 255.1 then ByteL := Round(WEx1) else ByteL := 255;
              //     ,   
              //   ,   
              //     R,G,B,L .
              Inc(ChnR[ByteR]);       // +1   Red 
              if  ChnR[ByteR] > ChnMax.MaxR
              then ChnMax.MaxR := ChnR[ByteR];
              Inc(ChnG[ByteG]);       // +1   Green 
              if  ChnG[ByteG] > ChnMax.MaxG
              then ChnMax.MaxG := ChnG[ByteG];
              Inc(ChnB[ByteB]);       // +1   Blue 
              if  ChnB[ByteB] > ChnMax.MaxB
              then ChnMax.MaxB := ChnB[ByteB];
              Inc(ChnL[ByteL]);       // +1   Light 
              if  ChnL[ByteL] > ChnMax.MaxL
              then ChnMax.MaxL := ChnL[ByteL];
              //    
              Inc(NumAllPnt);
            end;
            //    
            ProgressBar.Position := Row;
          end;  //
          //   ,    Images
          //   
          NormalizeGistogramForImage(ptGistRec);
          //   ,    
          CalcMathMDS(ptGistRec);
       end;
     except
          MessageDlg('CalculateAllGistogram :    .',
                      mtWarning, [mbOk], 0);
     end;
     //   
     ProgressBar.Position := 0;
  end; // of with
end;

// ========================================================================
//               END OF IMPLEMENTATION
// ========================================================================
end.
